///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ViewLogDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	if(xMessage == WM_INITDIALOG) // Received an initilize dialog message
	{
		ViewLogDialog_hWnd = xHandle;

		SendMessage(ViewLogDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Job Log");
		SendMessage(ViewLogDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(DialogIcon)));

        VLD.ListView_hWnd = GetDlgItem(ViewLogDialog_hWnd, 1000);

        int LVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
        SendMessage(VLD.ListView_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVStyle);

        VLD.LVColumb.cx        = 125;
        VLD.LVColumb.pszText   = "Start time";
        VLD.LVColumb.iSubItem  = 0;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 0, &VLD.LVColumb);

        VLD.LVColumb.cx        = 125;
        VLD.LVColumb.pszText   = "Stop time";
        VLD.LVColumb.iSubItem  = 1;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 1, &VLD.LVColumb);

        VLD.LVColumb.cx        = 110;
        VLD.LVColumb.pszText   = "Job type";
        VLD.LVColumb.iSubItem  = 2;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 2, &VLD.LVColumb);

        VLD.LVColumb.cx        = 100;
        VLD.LVColumb.pszText   = "Database";
        VLD.LVColumb.iSubItem  = 3;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 3, &VLD.LVColumb);

        VLD.LVColumb.cx        = 250;
        VLD.LVColumb.pszText   = "File name";
        VLD.LVColumb.iSubItem  = 4;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 4, &VLD.LVColumb);

        VLD.LVColumb.cx        = 70;
        VLD.LVColumb.pszText   = "KByte count";
        VLD.LVColumb.iSubItem  = 5;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 5, &VLD.LVColumb);

        VLD.LVColumb.cx        = 70;
        VLD.LVColumb.pszText   = "Result";
        VLD.LVColumb.iSubItem  = 6;
        VLD.LVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        VLD.LVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(VLD.ListView_hWnd, 6, &VLD.LVColumb);

        LoadJobLogDBIntoDialog();

		CenterWindow(ViewLogDialog_hWnd);

		return 0;
	}

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE) // Received A Message
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(VLD.ListView_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return 0;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_COMMAND) // Received a message
	{
        if(wParam==100) //- Ok (Dialog Menu Command)
        {
            EndDialog(ViewLogDialog_hWnd, 0);
            DestroyWindow(ViewLogDialog_hWnd);
            return 0;
        }

        if(wParam==101) //- Cancel (Dialog Menu Command)
        {
            EndDialog(ViewLogDialog_hWnd, 0);
            DestroyWindow(ViewLogDialog_hWnd);
            return 0;
        }

		return 0;
	}

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(ViewLogDialog_hWnd, 0);
		EndDialog(ViewLogDialog_hWnd, 0);
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

